
# SiFli_Trace

## 1. 概述

SiFli_Trace 是思澈公司自研工具，主要功能是抓取目标板LOG信息，该工具存放在 **固件包\solution\tools\SiFli_Trace** 路径下。

## 2. 环境配置

SiFli_Trace 免安装，可直接运行于WINDOWS系统，WINXP/WIN7/WIN10/WIN11…
当使用Jlink作为Trace接口时，需要基于Jlink硬件及其配套软件，建议操作如下：

- 购买官方Jlink设备并安装SEGGER官网JLink Windows驱动软件，本工具调试使用的版本为V680a。
- 在工具的配置文件SifliTrace.ini的[WND]项目中修改 JLINKPATH子项，eg: JLINKDLL=C:\Program Files (x86)\SEGGER\JLink

## 3. 功能介绍

<img src="png/SiFli_Trace_001.png"/>  
  
工具主界面如图所示，主要包括5个区域。  

### 3.1 功能控制区

- **新建**  
  添加一个新的接收子窗口，最多添加8个子窗口。
- **横排**  
  接收子窗口排列方式，横向排列。
- **纵向**  
  接收子窗口排列方式，纵向排列。
- **连接**  
  控制所有接收子窗口打开设备接收数据。
- **断开**  
  控制所有接收子窗口断开设备，停止接收数据。
- **保存**  
  控制所有接收子窗口将当前保存的数据文件保存，后面接收的数据会新建文件保存。
- **清空**  
  清空所有接收子窗口显示的内容，也会清空搜索窗口的信息。
- **刷新**  
  控制所有子窗口数据实时刷新。
- **不刷新**  
  控制所有子窗口数据停止刷新，停止刷新只是不实时显示新接收的数据，数据还是会接收并保存为文件。
- **搜索**  
  打开搜索子窗口。
- **设备**  
  打开设备管理器。
- **计算器**  
  打开计算器。
- **路径**  
  打开log保存路径。
- **DUMP**  
  打开AssertDump工具（读取死机现场）。
- **SERVER**  
  打开UsartServer工具（SF32LB52X和SF32LB56X平台用串口做调试时，需借助该工具）。
- **文件**  
  打开FsrwTool工具（目标板文件读写）。

### 3.2 功能按钮索引

功能按钮索引区是将功能控制区的按钮用小图标的方式显示，这样可以隐藏功能控制区，使接收子窗口有更大的显示区域。点击控件后面的下箭头可以选择其功能，比如添加删除按钮索引，隐藏打开空能控制等。

### 3.3 接收子窗口

可以最多添加8个接收子窗口，各子窗口有相同的界面，可以配置不同的参数。在窗口中有如下控件：

- **端口选择**  
  下拉列表中会显示识别到的串口号、JLink SN号、UART1_SOCKET、UART2_SOCKET，后面两个是跟UsartServer工具结合使用的，UsartServer连接串口进行调试时，通过SOCKET将固件的LOG数据分发出来，Trace工具连接SOCKET进行显示。  
- **波特率设置**  
  设置串口波特率或者JLink速率，注意串口波特率设置需要同固件中配置的一致。  
- **功能类型**  
  包括如下四种类型处理：  
  - **字符**  
    接收的数据直接按照字符显示，不做任何处理。
  - **HCI**  
    接收的HCI数据记录接收时间点，非HCI数据按照字符显示。
  - **HEX**  
    接收的数据直接按照打印器十六进制字节数据，不做其他处理。
  - **音频**  
    接收的音频数据特殊保存，非音频数据按照字符显示。
- **连接状态指示**  
  设备连接后显示绿色，未连接显示红色，设备连接上后丢失显示灰色，有数据接收图标会闪烁。
- **连接**  
  点击后连接/断开设备。
- **清空**  
  清空该子窗口显示的接收数据信息。
- **刷新**  
  子窗口接收数据后实时刷新，不勾选则只接收保存数据，不实时刷新界面。刷新会影响数据的实时接收，当有大量数据输出时可以关闭刷新来提高数据接收实时性。
- **显示**  
  子窗口接收数据后在界面显示，不勾选只接收保存数据，不在界面显示。实时显示会影响数据的实时接收，当有大量数据输出时可以关闭显示来提高数据接收实时性。
- **HCI数据显示**  
  当设置为HCI模式时，工具接收的数据会去解析HCI格式数据，用户根据需求是否显示HCI数据或者只显示收到数据的信息提示，HCI数据量大时显示数据会影响高数据接收实时性。
- **52X_BOOT**  
  选中该功能，SF32LB52X板子启动时，工具会强制发送命令让板子进入BOOT模式。
- **Front.**  
  连接HCI解析工具Front line，工具将会将HCI数据传递给Front line进行解析，具体使用方法参考后续章节。
- **RTS复位**  
  有的开发板使用串口的RTS管脚控制供电的开关，通过该按钮来方便的控制目标板复位重启。
- **log回放**  
  本工具保存的LOG可以再回放查看，点击后选择LOG文件即可，可以选择多个文件。
- **发送命令窗口**  
  通过该窗口可以发送finsh命令给目标板，默认会在输入的命令后面添加\r\n，输入命令后敲击enter键即可发送。
- **log名**  
  本窗口保存的LOG文件固定会添加的字符信息，目前未使用。
- **log大小**  
  保存的LOG文件分页大小,当超过该size时会保存文件并新建文件保存后面的数据。

### 3.4 发送子窗口

- **多窗口**  
  发送窗口的命令同时向多个勾选的子窗口发送，前提是子窗口设备需要处于连接状态。
- **窗口序号**  
  对应接收子窗口，根据需要勾选，默认全勾选。
- **发送状态指示**  
  循环发送命令时显示为绿色，否则会红色。
- **循环发送**  
  发送列表中勾选的命令循环发送。
- **异常终止**  
  循环发送模式下，如果检测到目标板的死机信息则停止发送。
- **单字节发送**  
  发送命令时单字节的方式发送，避免部分目标板连续发送数据处理不及时问题。
- **发送命令列表**  
  保存添加的发送命令，可以将常用的命令都添加在列表中方便使用。发送命令有4种格式：字符、HEX、CMD、FILE，默认为字符模式，双击对应的表格可以切换类型。
  - **字符**  
    发送finsh命令的场景，发送命令按照字符处理，发送时会在尾部添加\r\n。
  - **HEX**  
    发送HCI命令或者串口调试命令的场景，发送命令会转成十六进制字节发送。eg: 06 01 00 03
  - **CMD**  
    调用第三方工具的场景，直接调用第三方工具，如批处理文件等。eg: d:\debug.bat
  - **FILE**  
    发送内容从文件职工读取的场景，一般不会用上，主要用于大数据压力测试。 eg: d:\debug.bin

### 3.5 搜索子窗口

- **检索/监控信息**  可
  以配置三个检索监控信息，勾选的子项才会起效。
- **忽略大小写**  
  在检索监控信息是，是否忽略字符大小写。
- **搜索所有窗口**  
  在所有打开的接收子窗口进行检索监控。
- **搜索当前窗口**  
  只在当前选中的接收子窗口进行检索监控，当前选中的子窗口可以看工具最上面显示信息，如 “Sifli_Trace v2.3.3 - 窗口 1”。
- **监控检索信息**  
  是否实时监控要检索的信息，勾选则会实时监控，并在信息列表中显示具体信息。
- **监控错误信息**  
  是否监控目标板的错误信息，如 Assert等。
- **搜索**  
  根据配置搜索信息，会在信息列表中新加搜到的内容。
- **清空**  
  清空信息列表中显示的信息。
- **消息颜色设置**  
  设置不同信息在接收子窗口的显示颜色。
- **搜索列表**  
  显示检索/监控到的信息，第一列表示接收子窗口号，点击某一行相应的子窗口信息会被选中。子窗口信息清空时，搜索列表中对应的内容也会删除。

## 4. 使用方法

工具使用比较简单，直接双击运行，下面描述几种常用功能使用方法。

### 4.1 LOG抓取

- 选择端口号，速率，Trace类型；
- 点击 **连接** 打开设备连接；
- 工具开始启动数据接收，并将信息显示在子窗口，并保存文件，不同Trace类型保存的文件如下：
  - 字符类型/HEX类型  
    工具的log文件夹下 窗口x_端口_(年-月-日-时-分-秒)_ui.log 为子窗口界面的信息，添加了时间戳；  
    工具的log\base文件夹下 窗口x_端口_(年-月-日-时-分-秒).log 为原始数据，没添加时间戳；  
  - HCI类型  
    工具的log文件夹下 窗口x_端口_(年-月-日-时-分-秒)_ui.log 为子窗口界面的信息，添加了时间戳；  
    工具的log文件夹下 窗口x_端口_(年-月-日-时-分-秒).bin 为原始数据；  
    工具的log文件夹下 窗口x_端口_(年-月-日-时-分-秒).bintime 记录每条HCI接收的时间点；  
    工具的log文件夹下 窗口x_端口_(年-月-日-时-分-秒).pcap 为hci数据内容，用于wireshark软件解析；  
  - 音频数据
    工具的log文件夹下 窗口x_端口_(年-月-日-时-分-秒)_ui.log 为子窗口界面的信息，添加了时间戳；  
    工具的log\base文件夹下 窗口x_端口_(年-月-日-时-分-秒).log 为原始数据，没添加时间戳；  
    工具的log\窗口x_端口_(年-月-日-时-分-秒)_audio文件夹下保存抓取的音频数据以及错误信息；
:::{note}
当保存的文件超过子窗口设置的size时，或点击断开连接时，或点击**保存按钮**是，会自动保存log文件并重新创建新的文件。
:::

### 4.2 LOG回放

子窗口未连接设备进行Trace时，可以点击**log回放**，选择回放的log，log\base文件夹下的原始数据文件，也可以选择 HCI的原始数据文件（后缀为.bin）进行回放，支持多个文件选择。
:::{note}
工具弹出的选择log的窗口默认是 .bin 类型文件，如果选择其他后缀文件时，需要在文件名后面的文件类型选择。
:::

### 4.3 如何使用Frontline软件解析 HCI

- 安装Frontline软件；
- 修改工具路径下配置文件SiFli.ini文件的[WND]项目的FRONTLINEPATH子项，eg: FRONTLINEPATH=C:\Program Files (x86)\Frontline Test System II\Frontline 15.14
- 打开Frontline软件，设置 Options->Protocol Stack->Bluetooth HCI UART(H4) with autotraverse。
- 点击Frontline软件 Live->Start Capture启动数据接收。
- SiFli_Trace工具子窗口点击 Front. 连接设备，连接成功后HCI数据就会送到Frongline进行解析。
:::{note}
在实时抓log或者回放log时都可以按照上述操作解析HCI，注意只能有一个子窗口连接Frontline。
:::
