# -- coding: utf-8 --
from analyzer import Analyzer

class I2CAnalyzer(Analyzer):
    def run(self):
        super().run()
        i2c = self.read_peripheral(self.periph_name)
        inst_num = self.get_instance_num(self.periph_name)
        print(f"inst:{inst_num}")
        hpsys_rcc = self.read_peripheral("hpsys_rcc")
        hpsys_cfg = self.read_peripheral("hpsys_cfg")
        self.print_reg(i2c)
        # 读取HPSYS RCC指定寄存器的值
        print("模块: HPSYS_RCC")
        if hpsys_rcc:
            # 使用成员变量的方式获取某个寄存器值
            print(f"DLL1CR STG: {hpsys_rcc.DLL1CR.STG}")                
            print(f"CFGR: {hpsys_rcc.CFGR.HDIV}, {hpsys_rcc.CFGR.PDIV1}, {hpsys_rcc.CFGR.PDIV2}")      
            # 获取CFGR整个32bit值
            print(f"CFGR VAL: 0x{hpsys_rcc.CFGR.value:08X}")      


