# -- coding: utf-8 --

from analyzer import Analyzer
from analyzer import register_analyzer
from analyzer import LogLevel
from .rcc import RCCAnalyzer

class TSENAnalyzer(Analyzer):
    def run(self):
        super().run()
        self.log(LogLevel.INFO, f"{self.periph_name}分析启动")
        #self.log(LogLevel.INFO, "分析结果是基于当前时刻寄存器，如果通过hal函数使用TSEN则需要在函数中适当位置断点后再运行此分析")
        #inst_num = self.get_instance_num(self.periph_name)
        inst_error = 0
        
        #前置检查开始，如果出错就需要中止分析，以防读寄存器卡死或出现非法值
        HPSYS_RCC = self.read_peripheral("hpsys_rcc")
        HPSYS_CFG = self.read_peripheral("hpsys_cfg")
        #self.print_reg(HPSYS_CFG)
        
        #以下是根据实例编号需要区分的内容
        #检查时钟与复位
        if (HPSYS_RCC.ENR2.TSEN!=1):
            self.log(LogLevel.ERROR, f"{self.periph_name}模块时钟未开启",
                    "需将HPSYS_RCC的ENR2_TSEN置1以开启模块时钟")
            inst_error = 1
        if (HPSYS_RCC.RSTR2.TSEN!=0):
            self.log(LogLevel.ERROR, f"{self.periph_name}模块被复位",
                         "需将HPSYS_RCC的RSTR2_TSEN置0以释放模块复位")
            inst_error = 1

        #前置检查结束，如果出错就中止分析
        if (inst_error==1):
            self.log(LogLevel.ERROR, f"{self.periph_name}上述初始配置发现错误，分析无法继续进行",
                     "请将上述错误修正后重新启动分析")
            return
        #self.log(LogLevel.INFO, "初始配置分析完成，未发现错误，启动功能分析")

        #读取TSEN寄存器
        TSEN = self.read_peripheral(self.periph_name)

        #检查电路状态
        if(HPSYS_CFG.ANAU_CR.EN_BG !=1):
            self.log(LogLevel.ERROR, f"Bandgap 没有打开",
                     f"TSEN工作时应将HPSYS_CFG.ANAU_CR.EN_BG设为1")
            inst_error = 1
        if(TSEN.TSEN_CTRL_REG.ANAU_TSEN_EN !=1):
            self.log(LogLevel.ERROR, f"TSEN模块没有使能",
                     f"TSEN工作时应将TSEN.TSEN_CTRL_REG.ANAU_TSEN_EN设为1")
            inst_error = 1
        if(TSEN.TSEN_CTRL_REG.ANAU_TSEN_RSTB !=1):
            self.log(LogLevel.WARN, f"TSEN RSTB错误",
                     f"TSEN工作时，TSEN.TSEN_CTRL_REG.ANAU_TSEN_RSTB先置0后置1，最后应为1")
            inst_error = 1
        if(TSEN.TSEN_CTRL_REG.ANAU_TSEN_PU !=1):
            self.log(LogLevel.WARN, f"TSEN PU错误",
                     f"TSEN工作时，TSEN.TSEN_CTRL_REG.ANAU_TSEN_PU应为1")
            inst_error = 1
        if(TSEN.TSEN_CTRL_REG.ANAU_TSEN_RUN !=1):
            self.log(LogLevel.WARN, f"TSEN RUN错误",
                     f"TSEN工作时，TSEN.TSEN_CTRL_REG.ANAU_TSEN_RUN应为1")
            inst_error = 1

        #检查TSEN时钟频率
        rcc = RCCAnalyzer(self.device,"rcc",self.port,self.baudrate)
        pclk_freq, = rcc.get_clk("pclk_hpsys")
        clk_div = TSEN.TSEN_CTRL_REG.ANAU_TSEN_CLK_DIV
        tsen_freq=pclk_freq/clk_div
        if(tsen_freq>2):
            self.log(LogLevel.ERROR, f"TSEN时钟频率高于最高频率2MHz")
        self.log(LogLevel.INFO, f"TSEN 时钟频率为{tsen_freq}MHz,推荐设为1MHz或2MHz")


        #输出分析结果
        if (inst_error==1):
            self.log(LogLevel.ERROR, f"{self.periph_name}配置发现错误",
                     "请检查配置")
        else:
            self.log(LogLevel.INFO, f"{self.periph_name}分析结束，未发现错误")
        
register_analyzer("TSEN", TSENAnalyzer)

