# -- coding: utf-8 --
from analyzer import Analyzer
from analyzer import register_analyzer
from analyzer import LogLevel
from .rcc import RCCAnalyzer

class PDMAnalyzer(Analyzer):
    def run(self):
        super().run()
        self.log(LogLevel.INFO, f"{self.periph_name}分析启动")
        inst_num = self.get_instance_num(self.periph_name)
        inst_error = 0
        
        #前置检查开始，如果出错就需要中止分析，以防读寄存器卡死或出现非法值
        HPSYS_RCC = self.read_peripheral("hpsys_rcc")
        HPSYS_CFG = self.read_peripheral("hpsys_cfg")
        #self.print_reg(HPSYS_CFG)
        
        #以下是根据实例编号需要区分的内容
        #检查时钟与复位
        if (inst_num==1):
            if (HPSYS_RCC.ENR1.PDM1!=1):
                self.log(LogLevel.ERROR, f"{self.periph_name}模块时钟未开启",\
                         "需将HPSYS_RCC的ESR1_PDM1置1以开启模块时钟")
                inst_error = 1
            if (HPSYS_RCC.RSTR1.PDM1!=0):
                self.log(LogLevel.ERROR, f"{self.periph_name}模块被复位",\
                         "需将HPSYS_RCC的RSTR1_PDM1置0以释放模块复位")
                inst_error = 1
            clk_pin_list  = [7,22]
            data_pin_list = [8,23]

        #前置检查结束，如果出错就中止分析
        if (inst_error==1):
            self.log(LogLevel.ERROR, f"{self.periph_name}上述初始配置发现错误，分析无法继续进行",\
                     "请将上述错误修正后重新启动分析")
            return
        #self.log(LogLevel.INFO, "初始配置分析完成，未发现错误，启动功能分析")

        #以下是各实例共同的内容
        #PINMUX检查
        HPSYS_PINMUX = self.read_peripheral("hpsys_pinmux")
        #CLK IO检查
        clk_pin = 0x3f
        for i in clk_pin_list:
            if (HPSYS_PINMUX.__dict__[f"PAD_PA{i:02d}"].FSEL == 3):
                clk_pin = i
                break
        if (clk_pin == 0x3f): #没有分配IO
            self.log(LogLevel.ERROR, f"未找到CLK分配的IO",\
                     f"可分配IO为PA{clk_pin_list}")
            inst_error = 1
        else:
            self.log(LogLevel.INFO, f"CLK分配到PA{clk_pin:02d}")
            if ((HPSYS_PINMUX.__dict__[f"PAD_PA{clk_pin:02d}"].PE == 1)):
                self.log(LogLevel.WARN, f"CLK PA{clk_pin:02d}内部上下拉开启，可能产生漏电",\
                         f"可将HPSYS_PINMUX->PAD_PA{clk_pin:02d}.PE设为0以关闭内部上下拉电阻")
        #DATA IO检查
        data_pin = 0x3f
        for i in data_pin_list:
            if (HPSYS_PINMUX.__dict__[f"PAD_PA{i:02d}"].FSEL == 3):
                data_pin = i
                break
        if (data_pin == 0x3f): #没有分配IO
            self.log(LogLevel.WARN, f"未找到DATA分配的IO",\
                     f"可分配IO为PA{data_pin_list}")
        else:
            self.log(LogLevel.INFO, f"DATA分配到PA{data_pin:02d}")
            if (HPSYS_PINMUX.__dict__[f"PAD_PA{data_pin:02d}"].IE != 1):
                self.log(LogLevel.ERROR, f"DATA PA{data_pin:02d}输入未使能",\
                         f"将HPSYS_PINMUX->PAD_PA{data_pin:02d}.IE设为1")
            if ((HPSYS_PINMUX.__dict__[f"PAD_PA{data_pin:02d}"].PE == 1)):
                self.log(LogLevel.WARN, f"DATA PA{data_pin:02d}内部上下拉开启，可能产生漏电",\
                         f"可将HPSYS_PINMUX->PAD_PA{data_pin:02d}.PE设为0以关闭内部上下拉电阻")
        
        #读取PDM寄存器
        PDM = self.read_peripheral(self.periph_name)
        
        #检查PDM速率
        rcc = RCCAnalyzer(self.device,"rcc",self.port,self.baudrate);
        hclk_hpsys,clk_audpll = rcc.get_clk("hclk_hpsys","clk_audpll");
        print(hclk_hpsys);
        print(clk_audpll);
##        i2c_mode = I2C.CR.MODE;
##        if (i2c_mode == 0):
##            self.log(LogLevel.INFO, "I2C为标准模式(standard-mode)")
##            if (I2C.LCR.SLV > (2*I2C.WCR.CNT + 6)):
##                i2c_freq = 48000/(2*I2C.LCR.SLV + 7 + I2C.CR.DNF);
##            else:
##                i2c_freq = 48000/(I2C.LCR.SLV + 2*I2C.WCR.CNT + 6 + 7 + I2C.CR.DNF);
##        elif (i2c_mode == 1):
##            self.log(LogLevel.INFO, "I2C为快速或快速增强模式(fast-mode/fast-mode plus)")
##            if (I2C.LCR.FLV > (2*I2C.WCR.CNT + 6)):
##                i2c_freq = 48000/(2*I2C.LCR.FLV + 7 + I2C.CR.DNF);
##            else:
##                i2c_freq = 48000/(I2C.LCR.FLV + 2*I2C.WCR.CNT + 6 + 7 + I2C.CR.DNF);
##        else:
##            self.log(LogLevel.WARN, "I2C为高速模式，需使用专用格式访问",\
##                     "请确认是否需要3.4M高速模式(HS-mode)")
##            i2c_freq = 48000/(I2C.LCR.HLVH + I2C.LCR.HLVL + 7 + 2*I2C.CR.DNF);
##        self.log(LogLevel.INFO, f"接口频率约{i2c_freq:.0f}kHz")
##        if (i2c_freq >= 1000):
##            self.log(LogLevel.INFO, "外部上拉电阻推荐1K欧")
##        elif (i2c_freq >= 400):
##            self.log(LogLevel.INFO, "外部上拉电阻推荐4.7K欧")

        #检查PDM模块状态
        #TODO

            
        #输出分析结果
        if (inst_error==1):
            self.log(LogLevel.ERROR, f"{self.periph_name}配置发现错误",\
                     "请检查配置")
        else:
            self.log(LogLevel.INFO, f"{self.periph_name}分析结束，未发现错误")
        
register_analyzer("PDM", PDMAnalyzer)

