
# LightWork

## 1. 概述

LightWork 是思澈公司自研工具，主要功能是通过串口或者JLink实时读写寄存器，也可以导入保存的寄存器数据用于对比查看,该工具存放在 **固件包\solution\tools\LightWork** 路径下。

## 2. 环境配置

LightWork 免安装，可直接运行于WINDOWS系统，WINXP/WIN7/WIN10/WIN11…  

当使用Jlink读写寄存器时，需要基于Jlink硬件及其配套软件，建议操作如下：

- 购买官方Jlink设备并安装SEGGER官网JLink Windows驱动软件，本工具调试使用的版本为V680a。
- 在工具的配置文件 LightWork.ini中配置 JLinkARM.dll路径，有两种方式：
  - 不修改配置文件LightWork.ini，直接将 JLinkARM.dll 文件拷贝到工具根目录下。
  - 修改配置文件LightWork.ini 的[COMMON]项目中的JLINKDLL子项。eg: JLINKDLL=C:\Program Files (x86)\SEGGER\JLink\JLinkARM.dll

## 3. 功能介绍

<img src="png/LightWork_001.png" />  
  
工具主界面如图所示，主要有4个区域：基本控制区、内存读写区、IP选择区、寄存器显示区。  

### 3.1 基本控制区  

- **平台**  
  选择芯片类型，不同芯片对应各自的寄存器配置文件，各IP模块地址不同。  
- **数据源**  
  工具分析数据的来源，实时数据用串口或JLink读取，离线数据使用保存的寄存器数据。  
- **端口**  
  使用的串口号或者JLink的SN号。  
- **速率**  
  选择串口时串口速率需要同固件中串口配置的波特率一致，一般为1000000；JLink速率一般选择4000。  
- **展开等级**  
  寄存器显示区显示信息等级，展开1级只会显示IP的名称，展开2级会显示各IP的子项内容，展开3级会显示各IP的详细信息。  
- **写寄存器**  
  当修改寄存器显示区中 IP寄存器值时，是否立即写入到目标板中，不想立即写入可以通过每个寄存器或其子项的右键菜单写入。  
- **数据进制**  
  寄存器显示区各IP的详细信息使用10进制显示或是16进制显示。  
- **更新**  
  修改数据进制后，需要点击更新按钮才会用新的进制刷新显示。  
- **关看门狗**  
  控制关闭目标板的看门狗。  
- **halt HCPU**  
  停止大核CPU运行。  
- **halt LCPU**  
  停止小核CPU运行。  
- **数据读取**  
  根据 **数据源** 选择，更新寄存器显示区各寄存器内容。

### 3.2 内存读写区  

可以读写 SRAM/PSRAM 的数据，以及读取 NOR FLASH 的数据内容。

### 3.3 IP选择区  

- **交互控制界面**
  用列表的方式显示可以使用的IP，选择需要查看的IP显示在对应窗口上。当寄存器显示区有多个窗口时，勾选一个IP将会显示在被激活的子窗口上，也可以通过双击 IP对应的窗口编号来显示在对应的窗口上。  

- **寄存器检测界面**
  该功能用于检测部分IP的配置，输出检测信息，可以用来检查IP配置是否正确。

### 3.4 寄存器显示区  

最多有4个窗口用来显示寄存器数据，可以将多个IP的寄存器显示在一个窗口，也可将一个IP显示在不同窗口。  
每个IP寄存器的根节点以及第一级子节点都有右键菜单，可以单独控制对应的数据更新和写入。

## 4. 使用方法

### 4.1 寄存器显示

- 寄存器显示窗口打开关闭  
  寄存器显示窗口最多可以打开4个，通过勾选 **基本控制区** 的窗口checkbox，可以打开对应的子窗口，子窗口有最小化、最大化、关闭等系统控制按钮，不用的窗口直接关闭即可。  
- 将寄存器显示在当前激活窗口  
  勾选 IP寄存器列表中的某一项，可以显示在当前激活的窗口中，最后被选中的子窗口为当前激活子窗口，在工具最上面名称显示的地方会显示当前激活的窗口，如 LightWork v2.2 - window_0 。  
- 通过双击列表中窗口序号将寄存器显示在对应窗口  
  双击 IP寄存器列表中的某一项中的窗口标签，可以显示在对应的子窗口中。  
- 取消寄存器显示
  可以通过取消 IP寄存器列表中的某一项的选择来取消寄存器显示，取消选择后该IP在所有子窗口会删除。如果只想取消在某一个窗口的显示，只需要双击该IP的窗口索引即可。

:::{note}
可以将多个IP寄存器显示在一个窗口上，也可以将一个IP寄存器显示在不同窗口上，方便数据对比。
:::  

### 4.2 离线数据查看

- 在控制区域选选择芯片平台。
- 在控制区域选择数据类型为 **离线数据** 。
- 选择IP及窗口，在对应窗口显示出寄存器信息。
- 在显示窗口右键点击寄存器选择**导入数据**，然后选择对应的文件即可。

### 4.3 寄存器数据实时读写

- 在控制区域选择芯片平台。
- 在控制区域选择数据类型为 “UART读取”或者“JLink读取”，并配置对应端口。LB52X/LB56X平台可用串口，LB55X/LB56X/LB58X平台可用JLink。  
- 选择IP及窗口，在对应窗口显示出寄存器信息
- 设置好环境，可执行如下功能操作：
  - 寄存器读：点击“数据更新” 按钮，会读取选择的IP 寄存器值，保存在默认路径下， 同时更新寄存器显示区的数值。
  - 右键点击寄存器头或者寄存器子项，选择“读取寄存器”，会读取对应大项或子项数据，保存在默认路径下并更新当前窗口显示。
  - 寄存器写：修改对应寄存器数据，右键点击寄存器头或者寄存器子项，选择“设置寄存器”，会写入对应大项或子项数据。
  - 保存数据：右键点击寄存器头，选择“保存数据”可将当前显示的数据内容保存在指定路径

