
# GraphicsTool

## 1. 概述

GraphicsTool 是思澈公司自研工具， 主要功能是将图片/视频等素材转换为方案约定格式，该工具存放在 **固件包\solution\tools\GraphicsTool** 路径下。

## 2. 环境配置

GraphicsTool 免安装，可直接运行于WINDOWS系统，WINXP/WIN7/WIN10/WIN11…

## 3. 功能介绍

<img src="png/GraphicsTool_001.png"/>  
  
GraphicsTool主界面如图所示，包括功能控制区、转换文件选择区、图片/视频信息预览区、图片/视频转换参数配置区、运行信息显示区。  

### 3.1 功能控制区

:::{note}
功能控制区大部分控件在鼠标滑过时会有简单的使用描述。
:::  

- **转换运行**  
  控制所选功能的执行和停止，运行过程中点击可终止运行。  
- **创建目录**  
  按照平台方案定定义的文件结构创建目录，将图片/视频/动画/升级包/动态应用等资源拷贝到对应的目录，在专用模式下一键转换资源。  
- **重置参数**  
  将图片/视频转换参数区设置的参数重置为默认参数。  
- **快捷访问资源**  
  打开选择的资源路径，资源路径的设置在②区域的资源路径界面通过 **+路径** 按钮实现。  
- **快捷访问目标**  
  打开转换后的保存路径，该路径的设置在②区域的目标路径界面通过 **+路径** 按钮实现。  
- **功能控制区系统性参数**  
  - **功能**  
    可选功能：专用模式、图片转换、视频转换。专用模式是配合方案使用的，有固定的目录结构放置对应的资源，可以用**目录创建**按钮创建结构，该模式会隐藏参数设置页面，使用工具默认的参数。图片转换和视频转换功能会显示当前工具支持的参数设置页面供使用。  
  - **屏幕**  
    设置开发板的屏幕分辨率，专用模式下资源转换时会根据屏幕尺寸进行调整。该项参数在GraphicsTool.ini文件的 [LCD_PIX]项配置。  
  - **保存**  
    非专用模式功能时（图片转换或视频转换功能），图片/视频转换后保存在指定路径对应的文件夹下,如选择带目录结构，会在该文件夹下创建源文件的目录结构保存，如选择不带目录结构，则会直接保存在对应文件夹根目录，不创建源文件目录结构。  
  - **视频处理**  
    专用模式下视频文件转换的格式，目前方案支持三种方式。序列帧是指抽取视频的帧图片做EZIP转换，不包含音频数据；H264是正常的H264编码的视频文件，目前分辨率控制在320*240以内；EZIP是按照思澈平台特殊设置的编码方式，带有音频数据。序列帧和EZIP格式需要做EZIP转换，时间会比较长。  
  - **调整大小**  
    专用模式下图片/视频转换时，分辨率的调整控制方式。适配屏幕(铺满)是指按照屏幕分辨率进行调整，不保持源文件宽高比；适配屏幕(源宽高比)是指将资源放大到屏幕边界，保持源文件宽高比；保持源分辨率不变是指分辨率不做变化；  
  - **资源分辨率小于屏幕时不放大**  
    专用模式下图片/视频转换时，分辨率小于设置的分辨率时不调整，大于屏幕分辨率的在按照设置方式进行调整。  

### 3.2 转换文件选择区

:::{note}
需要注意在文件列表框中，只会显示文件夹以及跟当前处理功能相匹配的格式文件，具体可参考工具目录下GraphicsTool.ini文件的 [IMG_FILTER] 和 [VIDEO_FILTER] 配置。
文件选择区单击图片/视频文件时，会在信息预览区查看信息，双击文件时会打开/播放文件。
:::  
有几种方式可以将文件放入列表中：

- 使用功能控制区的“源选择”按钮选择资源路径  
- 文件选择区右键菜单“更新路径”选择资源路径  
- 拖拉文件/文件夹到文件显示区  

### 3.3 图片/视频信息预览区

点击文件列表中的图片或视频文件时，会在预览区显示一些关键信息，注意视频的参数获取会慢一些，会感觉到有一两秒的延时。

### 3.4 图片/视频转换参数配置区

- **图片转换参数**  
  - **生成格式**  
    选择目标图片格式，在思澈平台使用请选择EZIP格式，转换后的文件可以直接在平台上使用。  
  - **画质参数**  
    根据需求设置画质参数，数值越大画质越好，生成的文件越大，主要针对有损压缩格式的文件，如JPG等。  
  - **图片尺寸**  
    设置转换图片的尺寸以及缩放切割时的方式，建议将大分辨率图片转换为小分辨率图片。针对于设定宽高构建的矩形：铺满(不保持源宽高比，完整填充矩形)、完整(保持源宽高比，填充到矩形内)、自适应(保持源宽高比，覆盖住矩形)。  
- **视频转换参数**  
  - **视频参数**  
    - **视频格式**  
      选择视频容器格式，应用在思澈平台上一般可以选择序列帧、MP4、GIF动画。序列帧是只抽取视频中的帧图片做EZIP转换，不带声音。GIF动画是将视频转换为GIF动画，一般是截取视频中一部分来转换。MP4格式可以搭配不同编码格式，用于思澈平台的有H264(限制)和EZIP两种，H264(限制)是用H264编码且将分辨率限制在320*240以内；EZIP是适用于思澈的视频处理方式，在其他平台上无法使用。  
    - **编码格式**  
      选择视频编码方式，应用在思澈平台上参考上一条描述，其他使用场景根据需要选择。  
    - **视频帧率**  
      设置视频帧率。  
  - **音频参数**  
    - **音频控制**  
      音频参数不变、消除音频数据、单声道立体声选择，此项设置需结合视频源的音频数据情况。  
    - **编码格式**  
      音频编码方式，MP3或AAC。  
    - **音频码率**  
      选择音频码率（一般采用默认值）。  
    - **采样频率**  
      选择音频采样率，一般用44100。  
  - **视频尺寸**  
    - **分辨率**  
      选择分辨率设置方式。  
    - **宽度\*高度**  
      具体使用的分辨率值，格式320\*240；320*-1表示固定宽度，-1*240表示固定高度。  
    - **布局方式**  
      视频分辨率调整时处理方式，针对于设定宽高构建的矩形：铺满(不保持源宽高比，完整填充矩形)、完整(保持源宽高比，填充到矩形内)、自适应(保持源宽高比，覆盖住矩形)、区域截取(截取设定的区域部分)。  
    - **截取位置**  
      区域截取时选择截取的位置，除默认的几个位置外还可自定截取矩形的左上角顶点坐标。  
    - **顶点坐标点**  
      设定截取区域的左上顶点坐标，格式为 20*20。  
  - **时间参数**  
    - **截取方式**  
      视频转换时可全部转换或者针对某段时间或指定帧区间进行转换。  
    - **起止时间**  
      格式 00:00:20  (结束时间-1表示到结尾)。  
    - **起止帧号**  
      格式 40 (结束帧号-1表示到结尾)。  

:::{note}
示例：将480\*480分辨率的图片调整分辨率为1024\*600，几种布局方式得到的结果如下：  
铺满1024\*600  
<img src="png/GraphicsTool_002.png"/>  

自适应 1024\*600  
<img src="png/GraphicsTool_003.png"/>  

完整600\*600  
<img src="png/GraphicsTool_004.png"/>  
:::

### 3.5 运行状态显示区

显示当前转换文件、耗时、百分比进度等信息。转换结束且结果正确时，进度显示未100%，文件数显示为 n/n（如果前面数字小于后面数字说明有异常或者未结束）。

## 4. 使用方法

工具使用比较简单，直接双击运行，然后根据需求选择模式，按照如下方式操作。

### 4.1 图片转换功能使用

- 通过 **功能** 选择框选择图片转换功能。
- 通过 **屏幕** 选择框选择屏幕分辨率。
- 按照 3.2节描述方法，打开转换图片的路径，并在列表中选择要转换的图片。
- 按照 3.4节描述根据需求修改相应参数。
- 点击 **转换** 按钮执行图片转换功能，转换过程中在工具底部的转换信息显示区可以看到进度，待进度到100%表示转换成功。
- 点击 **目标路径** 按钮，进入转换后的存放路径，转换后的文件放在**photo**文件夹下，同时会生成一个**thum**文件夹用于存放缩略图。

### 4.2 视频转换功能使用

- 通过 **功能** 选择框选择视频转换功能。
- 通过 **屏幕** 选择框选择屏幕分辨率。
- 按照 3.2节描述方法，打开视频文件的路径，并在列表中选择要转换的视频。
- 按照3.4节描述根据需求修改相应参数。
- 点击 **转换** 按钮执行视频转换功能，转换过程中在工具底部的转换信息显示区可以看到进度，待进度到100%表示转换成功。
- 点击 **目标路径** 按钮，进入转换后的存放路径，视频转换后存放在**video**文件夹下，会同时生成缩略图文件(带_thum.bin)。

### 4.3 专用模式使用

- 通过 **功能** 选择框选择专用模式。
- 通过 **屏幕** 选择框选择屏幕分辨率。
- 通过 **视频处理** 选择框选择转换视频的格式，参考3.1描述。
- 通过 **调整大小** 选择框选择调整分辨率时如何处理，参考3.1描述。
- 按照3.2节描述方法，打开专用模式固定目录结构的资源路径，如果第一次使用，请用 **目录创建** 按钮创建方案指定的目录结构并选择该路径，将资源拷贝到对应文件夹下后，在文件列表右键菜单刷新列表，勾选需要转换的资源。
- 点击 **转换** 按钮执行转换功能，图片和视频按照预设的模式进行转换，开关机动画会做ezip转换，动态应用和动态表盘会解压缩，并在在对应目录创建完整的路径结构，生成文件信息列表，其他目录的文件直接拷贝。运行过程中在工具底部的转换信息显示区可以看到进度，待进度到100%表示转换成功。
- 点击 **路径** 按钮，进入转换后的存放路径，将整个文件夹结构拷贝到SD卡中使用。

### 4.4 推荐使用方式及步骤

本工具虽然提供了单独的图片转换和视频转换功能，但是需要设置的参数较多，一般是有特殊需求时使用。针对思澈平台方案，建议直接使用专用模式，不需要设置过多参数，只需将资源放置在对应的路径下一键转换即可。
首次打开工具，默认选择的是专用模式，并且在工具路径下会创建Resource_Src文件夹，里面放置方案设定的目录结构，使用时也可根据需求选择路径创建目录结构，并在目录上添加项目名称用于标记，如**FAQ1**描述。
创建好目录结构并使用该路径作为资源路径后，可以将资源拷贝到对应的目录下，在工具的转换文件选择区，点击**刷新**按钮可以显示新加的资源，注意只有图片/视频/GIF等文件会显示出来。勾选需要转换的文件，或者全部勾选。
专用模式下需要设置的参数：选择屏幕分辨率、选择视频处理格式（参考3.1节**视频处理**描述）、选择调整大小方式（参考3.1节**调整大小**描述）。
点击 **转换** 按钮启动资源转换，工具下边状态栏的描述及进度条显示转换进度，转换完后，点击 **目标路径** 按钮进入转换后的保存路径，可以将整个文件夹拷贝到SD卡中插入硬件板使用。

