import * as lv from "lv"
import { app } from "lvapp"
import * as nvm from "nvm"
import { label } from "/support_script/qjs/label.js"
import { img } from "/support_script/qjs/img.js"
import {app_get_str} from "./JA_app3_language.js"
import * as lv_enums from "/support_script/qjs/lv_enums.js"

class ja_app extends app {
	constructor() {
		super();
        this.config = this.path() + "config.json";
        this.data_string = undefined;
        this.obj_read = undefined;
    }
    init_nvm(){
        try{
            this.data_string = nvm.read(this.config);
            this.obj_read = JSON.parse(this.data_string);
        }
        catch(err){
            print("nvm read failed, use default")
            var user = {
                id:1,
                name:"Bob",
                scores:[90,85]
            };
            const success = nvm.write(this.config, JSON.stringify(user));
            if(success){
                print("write success");
            }
            this.data_string = nvm.read(this.config);
            this.obj_read = JSON.parse(this.data_string);
        }
        
        print("id ", this.obj_read.id);
        print("name ", this.obj_read.name);
        print("scores ", this.obj_read.scores);
    }
    
    start() {
        
        this.init_nvm();
        
        this.id = new label(this.root());
        this.id.set_local_font(lv_enums.FONT_TITLE, lv.color_make(0xff,0xff,0xff));
        this.id.set_text("ID: " + String(this.obj_read.id));
		this.id.align(lv_enums.ALIGN_TOP_LEFT, 20, 10);
        
        this.name = new label(this.root());
        this.name.set_local_font(lv_enums.FONT_TITLE, lv.color_make(0xff,0xff,0xff));
        this.name.set_text("NAME: " + String(this.obj_read.name));
		this.name.align(lv_enums.ALIGN_TOP_LEFT, 20, 60);
        
        this.score = new label(this.root());
        this.score.set_local_font(lv_enums.FONT_TITLE, lv.color_make(0xff,0xff,0xff));
        this.score.set_text("SCORE: " + String(this.obj_read.scores));
		this.score.align(lv_enums.ALIGN_TOP_LEFT, 20, 110);

        this.obj_read.id++;
        if(this.obj_read.name == "Bob"){
            this.obj_read.name = "Linda";
        }else{
            this.obj_read.name = "Bob";
        }
        this.obj_read.scores[0] = this.obj_read.scores[0] ^ this.obj_read.scores[1];
        this.obj_read.scores[1] = this.obj_read.scores[0] ^ this.obj_read.scores[1];
        this.obj_read.scores[0] = this.obj_read.scores[0] ^ this.obj_read.scores[1];

        nvm.write(this.path() + "config.json", JSON.stringify(this.obj_read));
    }

    resume() {
        print("resume");
    }
    pause(){
        print("pause");
    }
}

globalThis.JA_app3 = {
    root:ja_app
};
app_get_str("key_qjs_name","ja_app3"); ֕0