import * as lv from "lv"
import { app } from "lvapp"
import { seqframe } from "/support_script/qjs/seqframe.js"
import { label } from "/support_script/qjs/label.js"
import {app_get_str} from "./JW_wf2_language.js"

class JW_wf2 extends app {
	constructor() {
		super();
        this.time_ul_path = this.path() + "dig_1.bin"
        this.time_ur_path = this.path() + "dig_2.bin"
        this.time_bl_path = this.path() + "dig_2.bin"
        this.time_br_path = this.path() + "dig_1.bin"
    }
    refresh() {
        var cur_time = new Date();
        print("time:",cur_time.getHours(),":",cur_time.getMinutes());
        this.time_ul.set_src_seq(this.time_ul_path, cur_time.getHours() / 10);
        this.time_ur.set_src_seq(this.time_ur_path, cur_time.getHours() % 10);
        this.time_bl.set_src_seq(this.time_bl_path, cur_time.getMinutes() / 10);
        this.time_br.set_src_seq(this.time_br_path, cur_time.getMinutes() % 10);
        this.date_label.set_text(cur_time.toDateString());
        this.date_label.align(5, 0, -15);
    }
    start() {

        // Upper left
        this.time_ul = new seqframe(this.root());
        this.time_ul.set_src_seq(this.time_ul_path, 0);
        this.time_ul.set_pos(27, 41);

        // Upper right
        this.time_ur = new seqframe(this.root());
        this.time_ur.set_src_seq(this.time_ur_path, 0);
        this.time_ur.set_pos(179, 51);

        // Bottom left
        this.time_bl = new seqframe(this.root());
        this.time_bl.set_src_seq(this.time_bl_path, 0);
        this.time_bl.set_pos(37, 199);

        // Bottom right
        this.time_br = new seqframe(this.root());
        this.time_br.set_src_seq(this.time_br_path, 0);
        this.time_br.set_pos(189, 209);

        this.date_label = new label(this.root());
        this.date_label.set_local_font(24, lv.color_make(0xff,0xff,0xff));
        this.refresh();
    }

    resume() {
        this.task(
            function () {
                this.refresh();
            }
            , 1000
        );
    }
    pause(){
        this.task();
    }
}

globalThis.JW_wf2 = {
    root:JW_wf2
};
app_get_str("key_qjs_name","js_wf2");   XV