import * as lv from "lv"
import { app } from "lvapp"
import * as lv_enums from "/support_script/qjs/lv_enums.js"
import { label } from "/support_script/qjs/label.js"
import { ezipa } from "/support_script/qjs/ezipa.js"
import {app_get_str} from "./JW_wf5_language.js"

class JW_wf5 extends app {
    constructor() {
		super();
        this.apng_src = this.path() + "apng.bin"
        this.apng_th = this.path() + "apng_th.bin"
    }

    refresh() {
        var cur_time = new Date();
        if (cur_time.getMinutes() != this.last_min) {
            this.hour.set_text(String(cur_time.getHours()).padStart(2,'0'))
            this.min.set_text(String(cur_time.getMinutes()).padStart(2,'0'));
            this.date.set_text(cur_time.toDateString());
			this.last_min = cur_time.getMinutes();
            this.hour.align_to(this.dot.nativeobj, lv_enums.ALIGN_OUT_LEFT_MID, 0, 7);
            this.min.align_to(this.dot.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 0, 7);
            this.date.align(lv_enums.ALIGN_BOTTOM_MID, 0, -5);
        }
    }

    start() {
        // GIF image
        this.anim = new ezipa(this.root());
        this.anim.set_src(this.apng_src);
        this.anim.set_surface(this.apng_th);
        this.anim.align(lv_enums.ALIGN_CENTER, 0, 0);

        // Dot
        this.dot = new label(this.root());
        this.dot.set_text(":");
        this.dot.set_local_font(lv_enums.FONT_SUPER, lv.color_make(0xff,0xff,0xff));
		this.dot.align(lv_enums.ALIGN_BOTTOM_MID, 0, -37);

        // Hour 
        this.hour = new label(this.root());
        this.hour.set_local_font(lv_enums.FONT_SUPER, lv.color_make(0xff,0xff,0xff));
		this.hour.align_to(this.dot.nativeobj, lv_enums.ALIGN_OUT_LEFT_MID, 0, 7);

        // Minute
        this.min = new label(this.root());
        this.min.set_local_font(lv_enums.FONT_SUPER, lv.color_make(0xff,0xff,0xff));
		this.min.align_to(this.dot.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 0, 7);

        // Date
        this.date = new label(this.root());
        this.date.set_local_font(lv_enums.FONT_SUBTITLE, lv.color_make(0xff,0xff,0xff));
		this.date.align(lv_enums.ALIGN_BOTTOM_MID, 0, -5);
        this.refresh();
        this.last_min = -1;

    }
    pause() {
        this.task();
        this.anim.pause();
    }
    resume() {
        this.refresh();
        this.task(
            function () {
                this.refresh();
            }
            , 1000
        );
        this.anim.resume();
    }
}
globalThis.JW_wf5 = {
    root : JW_wf5,
};
app_get_str("key_qjs_name","js_wf5"); ~