/*
	打开文件
	@param path: 打开的文件名称
	@param flag: 以下的组合，可以OR来表示
		O_RDONLY - 只读
		O_WRONLY - 只写
		O_RDWR   - 读写
		O_APPEND - 添加
		O_CREATE - 创建
	@param mode: Reserved.
	@returns 创建成功是文件描述符，以正整数表示，负整数表示失败 
*/
export declare function open(path: String, flag:enum, mode:number): number;


/*
	关闭文件
	@param fd: 文件描述符，以正整数表示
	@returns 0:成功，-1: 表示失败 
*/
export declare function close(fd: number):number;

export declare function seek(fd: number, pos: number, offset: number ):number;
export declare function read(fd: number, buf: ByteArray, pos: number, length: number ):number;
export declare function write(fd: number, buf: ByteArray, pos: number, length: number ):number;
export declare function getcwd():String;
export declare function chdir(path: String):number;
export declare function mkdir(path: String):number;
export declare function readdir(path: String):{path_array:StringArray, errocode:number};

/*
	返回文件属性
	@param fd: 文件描述符，以正整数表示
	@returns object {
		dev; 	//device 文件的设备编号
		ino; 	//inode 文件的i-node
		mode; 	//protection 文件的类型和存取的权限
		nlink; 	//number of hard links 连到该文件的硬连接数目, 刚建立的文件值为1.
		uid; 	//user ID of owner 文件所有者的用户识别码
		gid; 	//group ID of owner 文件所有者的组识别码
		rdev; 	//device type 若此文件为装置设备文件, 则为其设备编号
		size; 	//total size, in bytes 文件大小, 以字节计算,
	}		
*/
export declare function stat(fd: number): object;
export declare function rename(oldpath: String, newpath:String):number;
