import * as lv from "lv"
import { app } from "lvapp"
import * as lv_enums from "/support_script/qjs/lv_enums.js"
import { label } from "/support_script/qjs/label.js"
import { sfgif } from "/support_script/qjs/sfgif.js"
import {app_get_str} from "./JW_wf4_language.js"

class JW_wf4 extends app {
    constructor() {
		super();
        if (lv.get_agif_support()) {
            this.gif_src = this.path() + "anim.agif";
            print("agif support!")
        }
        else {
            this.gif_src = this.path() + "anim.gif";
            print("agif not support!")
        }

        this.thum_src = this.path() + "agif_th.bin";
    }

    refresh() {
        var cur_time = new Date();
        if (cur_time.getMinutes() != this.last_min) {
            this.hour.set_text(String(cur_time.getHours()).padStart(2,'0'))
            this.hour.align_to(this.dot.nativeobj, lv_enums.ALIGN_OUT_LEFT_MID, 0, 7);
            this.min.set_text(String(cur_time.getMinutes()).padStart(2,'0'));
            this.min.align_to(this.dot.nativeobj,lv_enums.ALIGN_OUT_RIGHT_MID, 0, 7);
            this.date.set_text(cur_time.toDateString());
			this.last_min = cur_time.getMinutes();
        }
    }

    start() {
        // GIF image
        this.anim = new sfgif(this.root());
        this.anim.open(this.gif_src, this.thum_src, 0, 0, 0, 16);
        this.anim.align(lv_enums.ALIGN_CENTER, 0, 0);

        // Dot
        this.dot = new label(this.root());
        this.dot.set_text(":");
        this.dot.set_local_font(lv_enums.FONT_SUPER, lv.color_make(0xff,0xff,0xff));
		this.dot.align(lv_enums.ALIGN_BOTTOM_MID, 0, -37);

        // Hour 
        this.hour = new label(this.root());
        this.hour.set_local_font(lv_enums.FONT_SUPER, lv.color_make(0xff,0xff,0xff));
		this.hour.align_to(this.dot.nativeobj, lv_enums.ALIGN_OUT_LEFT_MID, 0, 7);

        // Minute
        this.min = new label(this.root());
        this.min.set_local_font(lv_enums.FONT_SUPER, lv.color_make(0xff,0xff,0xff));
		this.min.align_to(this.dot.nativeobj,lv_enums.ALIGN_OUT_RIGHT_MID, 0, 7);

        // Date
        this.date = new label(this.root());
        this.date.set_local_font(lv_enums.FONT_SUBTITLE, lv.color_make(0xff,0xff,0xff));
		this.date.align(lv_enums.ALIGN_BOTTOM_MID, 0, -5);

        this.last_min = -1;
        this.refresh();
    }
    pause() {
        this.task();
        this.anim.pause();
    }
    resume() {
        this.refresh();
        this.task(
            function () {
                this.refresh();
            }
            , 1000
        );
        this.anim.resume();
    }
    stop() {
        this.anim.close();
    }
}
globalThis.JW_wf4 = {
    root : JW_wf4,
};
app_get_str("key_qjs_name","js_wf4"); ( <