import * as lv from "lv"
import * as os from "os"
import * as std from "std"
import {app} from "lvapp"
import * as lv_enums from "/support_script/qjs/lv_enums.js"
import {qrcode} from  "/support_script/qjs/qrcode.js"
import {lvsfbarcode} from "/support_script/qjs/lvsfbarcode.js"
import {app_get_str} from "./JA_app1_language.js"


function arrayBufferToString(buffer){
    return String.fromCharCode.apply(null, new Uint16Array(buffer));
}

function stringToArrayBuffer(str) {
    var buf = new ArrayBuffer(str.length * 2);
    var bufView = new Uint16Array(buf);
    for (var i = 0, strLen = str.length; i < strLen; i++) {
        bufView[i] = str.charCodeAt(i);
    }
    return buf;
}

var string = "0705632441974";
var txt = "0123456-ABC-abcd";
class JA_app1 extends app{	
    constructor() {
		super();
    }
    
    refresh() {
        this.count++;
        print("count ", this.count);
    }
    
	start() {

		// Demo for QRcode		
		this.qrcode = new qrcode(this.root());
		this.qrcode.setparam(200, lv.color_make(0xc0,0xc0,0xc0), lv.color_make(0xFF,0xFF,0xFF));
		this.qrcode.set_text(txt, txt.length); 
		this.qrcode.align(lv_enums.ALIGN_TOP_MID, 0, 0);
		
		this.qrcode.set_event_cb(
			function(event){
				if (event==lv_enums.EVENT_SHORT_CLICKED){
                    print("qrcode event ", event);
					lv.gui_app_self_exit();
                }
			}
		);
						
		// Demo for Barcode

        this.barcode = new lvsfbarcode(this.root());
		this.barcode.set_size(300, 100);
		this.barcode.set_text(string, 66);
        this.barcode.align(lv_enums.ALIGN_BOTTOM_MID, 0, 0);
        this.barcode.set_event_cb(
			function(event){
				if(event == lv_enums.EVENT_SHORT_CLICKED){
                    print("barcode event ", event);
					lv.qjs_app_page_create("page1");
                }
			}
		);  
		
        print("Started\n");
    }    
	resume() {
		// Demo for OS file access
		this.f=os.open("/a.txt", os.O_RDWR | os.O_CREAT | os.O_TRUNC);
        print("f=",this.f);
        if(this.f > 0){
            const buffer1 = stringToArrayBuffer('Hello, QuickJS File Operations!');
            os.write(this.f, buffer1, 0, buffer1.byteLength)
            print("write:", arrayBufferToString(buffer1));
            os.seek(this.f, std.SEEK_SET, 0);
            const buffer = new ArrayBuffer(buffer1.byteLength);
            os.read(this.f,buffer,0, buffer1.byteLength);
            print("read:", arrayBufferToString(buffer));
            os.close(this.f);
        }

		// Demo for OS directory
		os.chdir("/support_script/qjs");
		print(os.getcwd());
		os.chdir("/");
		var local_files=os.readdir("/");
		print(local_files[0].length);
		for (var i=0;i<local_files[0].length;i++)
		{ 		
			print(local_files[0][i]);
		}		
        
		// Demo for task
		this.count=0;
		this.task(
			function() {
                this.refresh();
			}
			, 1000
		);
	}
    
    pause(){
        this.task();
    }
    stop(){
        print("stop");
    }  
}
//先定义，再赋值
//globalThis.JA_app1 = {};
//globalThis.JA_app1.root = JA_app1;

//初始化赋值
globalThis.JA_app1 = {
    root : JA_app1,
};

app_get_str("key_qjs_name","ja_app1"); K"