import * as lv from "lv"
import { app } from "lvapp"
import { seqframe } from "/support_script/qjs/seqframe.js"
import { img } from "/support_script/qjs/img.js"
import * as lv_enums from "/support_script/qjs/lv_enums.js"
import { label } from "/support_script/qjs/label.js"
import {app_get_str} from "./JW_wf6_language.js"

class JW_wf6 extends app {
	constructor() {
		super();
        this.n_path = this.path() + "n.bin";
        this.mn_path = this.path() + "mn.bin";
        this.w_path = this.path() + "w.bin";
        this.sn_path = this.path() + "sn.bin";
        this.apm_path = this.path() + "apm.bin";
    }
    refresh() {
        var cur_time = new Date();
        var second = cur_time.getSeconds();
        if (second != this.last_sec) {
            this.last_sec = second;
            this.sec_10x.set_src_seq(this.n_path, second / 10);
            this.sec_1x.set_src_seq(this.n_path, second % 10);
            var min = cur_time.getMinutes();
            if (min != this.last_min) {
                this.last_min = min;
                this.min_10x.set_src_seq(this.n_path, min / 10);
                this.min_1x.set_src_seq(this.n_path, min % 10);
                var hour = cur_time.getHours();
                if (hour != this.last_hour) {
                    this.last_hour = hour;
                    this.hour_10x.set_src_seq(this.n_path, hour / 10);
                    this.hour_1x.set_src_seq(this.n_path, hour % 10);
                    if (hour > 11)
                        this.apm.set_src_seq(this.apm_path, 1);
                    else
                        this.apm.set_src_seq(this.apm_path, 0);
                    this.month.set_src_seq(this.mn_path, cur_time.getMonth() + 1);
                    this.wk.set_src_seq(this.w_path, cur_time.getDay());
                    this.day_10x.set_src_seq(this.sn_path, cur_time.getDate() / 10);
                    this.day_1x.set_src_seq(this.sn_path, cur_time.getDate() % 10);
                }
            }
        }
    }

    start() {
        // Back ground
        this.bg = new img(this.root());
        this.bg.set_src(this.path() + "bg.bin");

        // Kcal
        this.kcal = new label(this.root());
        this.kcal.align(lv_enums.ALIGN_BOTTOM_MID, -110, -60);
        this.kcal.set_local_font(lv_enums.FONT_NORMAL, lv.color_make(0xff,0xff,0xff));
        this.kcal.set_text("--");
        this.kcal.add_flag(lv_enums.FLAG_CLICKABLE);
        
        this.kcal.bind("rt_step_calories", lv_enums.EVENT_REFRESH,
            function (id, type, calorie) {
                print("id ",id, " type ", type);
                if(calorie != undefined){
                    print("calorie: ", calorie);
                    this.set_text(String(calorie));
                }
            })
        this.kcal.set_event_cb(
            function (event) {
                if (event == lv_enums.EVENT_CLICKED)
                    lv.gui_app_run("sport");
            })

        // Heart rate
        this.hr = new label(this.root());
        this.hr.align(lv_enums.ALIGN_TOP_MID, -110, 70);
        this.hr.set_local_font(lv_enums.FONT_NORMAL, lv.color_make(0xFF,0XFF,0XFF));
        this.hr.set_text("--");
        this.hr.add_flag(lv_enums.FLAG_CLICKABLE);
        this.hr.bind("rt_hr", lv_enums.EVENT_REFRESH,
            function (id, type, hr) {
                print("id ",id, " type ", type);
                if(hr != undefined){
                    print("hr:", hr);
                    this.set_text(String(hr));
                }
            })
        this.hr.set_event_cb(
            function (event) {
                if (event == lv_enums.EVENT_CLICKED)
                    lv.gui_app_run("heartrate");
            })

        // Step
        this.step = new label(this.root());
        this.step.align(lv_enums.ALIGN_TOP_MID, 114, 70);
        this.step.set_local_font(lv_enums.FONT_NORMAL, lv.color_make(0xFF,0XFF,0XFF));
        this.step.set_text("--");
        this.step.add_flag(lv_enums.FLAG_CLICKABLE);
        this.step.bind("rt_step", lv_enums.EVENT_REFRESH,
            function (id, type, step) {
                print("id ",id, " type ", type);
                if(step != undefined){
                    print("step: ", step);
                    this.set_text(String(step));
                }
            })
        this.step.set_event_cb(
            function (event) {
                if (event == lv_enums.EVENT_CLICKED)
                    lv.gui_app_run("sport");
            })


        // Distance
        this.dist = new label(this.root());
        this.dist.align(lv_enums.ALIGN_BOTTOM_MID, 114, -60);
        this.dist.set_local_font(lv_enums.FONT_NORMAL, lv.color_make(0xFF,0XFF,0XFF));
        this.dist.set_text("--");
        this.dist.add_flag(lv_enums.FLAG_CLICKABLE);
        this.dist.bind("rt_step_distance", lv_enums.EVENT_REFRESH,
            function (id, type, distance) {
                print("id ",id, " type ", type);
                if(distance != undefined){
                    print("distance: ", distance);
                    this.set_text(String(distance));
                }
            })
        this.dist.set_event_cb(
            function (event) {
                if (event == lv_enums.EVENT_CLICKED)
                    lv.gui_app_run("sport");
            })

        this.dist_unit = new img(this.root());
        this.dist_unit.set_pos(280, 387);
        this.dist_unit.set_src(this.path() + "mi.bin");

        // Time 
        this.hour_10x = new seqframe(this.root());
        this.hour_10x.set_src_seq(this.n_path, 0);
        this.hour_10x.set_pos(58, 183);

        this.hour_1x = new seqframe(this.root());
        this.hour_1x.set_src_seq(this.n_path, 0);        
        this.hour_1x.set_pos(92, 183);

        this.min_10x = new seqframe(this.root());
        this.min_10x.set_src_seq(this.n_path, 0);   
        this.min_10x.set_pos(151, 183);

        this.min_1x = new seqframe(this.root());
        this.min_1x.set_src_seq(this.n_path, 0);   
        this.min_1x.set_pos(185, 183);
        
        this.last_min = -1;
        this.sec_10x = new seqframe(this.root());
        this.sec_10x.set_src_seq(this.n_path, 0);   
        this.sec_10x.set_pos(237, 183);

        this.sec_1x = new seqframe(this.root());
        this.sec_1x.set_src_seq(this.n_path, 0);  
        this.sec_1x.set_pos(271, 183);
        
        this.dot1 = new img(this.root());
        this.dot1.set_pos(120, 180);
        this.dot1.set_src(this.path() + "n_dot.bin");
        
        this.dot2 = new img(this.root());
        this.dot2.set_pos(210, 180);
        this.dot2.set_src(this.path() + "n_dot.bin");

        // Date
        this.month = new seqframe(this.root());
        this.month.set_src_seq(this.mn_path, 1);  
        this.month.set_pos(161, 267);
        
        this.wk = new seqframe(this.root());
        this.wk.set_src_seq(this.w_path, 0); 
        this.wk.set_pos(74, 267);
        
        this.day_10x = new seqframe(this.root());
        this.day_10x.set_src_seq(this.sn_path, 0); 
        this.day_10x.set_pos(265, 269);
        
        this.day_1x = new seqframe(this.root());
        this.day_1x.set_src_seq(this.sn_path, 0); 
        this.day_1x.set_pos(279, 269);
        
        this.apm = new seqframe(this.root());
        this.apm.set_src_seq(this.apm_path, 0); 
        this.apm.set_pos(167, 232);
        this.last_hour = -1;

        this.last_sec = -1;
        this.refresh();
    }
    pause() {
        this.task();
    }
    resume() {
        this.task(
            function () {
                this.refresh();
            }
            , 500
        );
        this.refresh();
    }
}
globalThis.JW_wf6 = {
    root : JW_wf6
};
app_get_str("key_qjs_name","js_wf6"); j*U