import * as lv from "lv"
import { app } from "lvapp"
import { anim }  from "anim"
import {app_get_str} from "./JA_app5_language.js"
import { label } from "/support_script/qjs/label.js"
import * as lv_enums from "/support_script/qjs/lv_enums.js"

class ja_app extends app {
	constructor() {
		super();
        
        //0 top left->top right
        //1 top right->bottom right
        //2 bottom right->bottom left
        //3 bottom left->top left
        //4 top left->bottom right
        //5 bottom left->top right
        
        this.type = 0;
        this.type1 = 2;
        this.scr_w = 200;
        this.scr_h = 200;
        this.anim = undefined;
        this.anim1 = undefined;
    }

    create_anim(type){
        print("create_anim, type ", type);
        var a = new anim();
        if(type == 0){
            a.set_values(0,  this.scr_w); //x or y
            a.set_path(a.PATH_LINEAR)
        }
        else if(type == 1){
            a.set_values(0,  this.scr_w); //x or y
            a.set_path(a.PATH_EASE_IN)
        }
        else if(type ==2){
            a.set_values(this.scr_w, 0); //x or y
            a.set_path(a.PATH_EASE_OUT)
        }
        else if(type == 3){
            a.set_values(this.scr_w, 0); //x or y
            a.set_path(a.PATH_OVERSHOOT)
        }
        else if(type == 4 || type == 5){
            a.set_values(0,  Math.sqrt(this.scr_w * this.scr_w)); //x and y
            a.set_path(a.PATH_BOUNCE)
        }
        a.set_time(1000);
        a.set_delay(2000);
        a.set_start_cb(function(anim){
            print("anim start");
        });
        var that = this;
        a.set_ready_cb(function(anim){
            that.type++;
            that.type %= 6;
            if(that.anim != undefined){
                delete that.anim;
            }
            that.anim = that.create_anim(that.type);
        });

        a.set_exec_cb(function(val){
            if(that.type == 0 || that.type == 2)
               that.label.set_x(val)
            else if(that.type == 1 || that.type == 3)
               that.label.set_y(val)
            else if(that.type == 4)
                that.label.set_pos(val, val);
            else if(that.type == 5)
                that.label.set_pos(val, that.scr_h - val);
        });
        //a.set_playback_time(200);
        //a.set_playback_delay(200);
        a.set_early_apply(false);
        a.start();
        print("anim set start");
        return a;
    }
    
    create_anim1(type){
        print("create_anim, type ", type);
        var a = new anim();
        if(type == 0){
            a.set_values(0,  this.scr_w); //x or y
            a.set_path(a.PATH_LINEAR)
        }
        else if(type == 1){
            a.set_values(0,  this.scr_w); //x or y
            a.set_path(a.PATH_EASE_IN)
        }
        else if(type ==2){
            a.set_values(this.scr_w, 0); //x or y
            a.set_path(a.PATH_EASE_OUT)
        }
        else if(type == 3){
            a.set_values(this.scr_w, 0); //x or y
            a.set_path(a.PATH_OVERSHOOT)
        }
        else if(type == 4 || type == 5){
            a.set_values(0,  Math.sqrt(this.scr_w * this.scr_w)); //x and y
            a.set_path(a.PATH_BOUNCE)
        }
        a.set_time(1000);
        a.set_delay(2000);
        a.set_start_cb(function(anim){
            print("anim start");
        });
        a.set_ready_cb(function(anim){
            that.type1++;
            that.type1 %= 6;
            if(that.anim1 != undefined){
                delete that.anim1;
            }
            that.anim1 = that.create_anim1(that.type1);
        });
        var that = this;
        a.set_exec_cb(function(val){
            if(that.type1 == 0 || that.type1 == 2)
               that.label1.set_x(val)
            else if(that.type1 == 1 || that.type1 == 3)
               that.label1.set_y(val)
            else if(that.type1 == 4)
                that.label1.set_pos(val, val);
            else if(that.type1 == 5)
                that.label1.set_pos(val, that.scr_h - val);
        });
        //a.set_playback_time(200);
        //a.set_playback_delay(200);
        a.set_early_apply(false);
        a.start();
        print("anim set start");
        return a;
    }
    
    start() {
        print("start");
        this.anim = this.create_anim(this.type);
        this.anim1 = this.create_anim1(this.type1);
        
        this.label = new label(this.root());
        this.label.set_local_font(lv_enums.FONT_BIGL, lv.color_make(0xff,0,0));
        this.label.set_text("Anim");
		this.label.set_pos(0, 0);
        
        this.label1 = new label(this.root());
        this.label1.set_local_font(lv_enums.FONT_BIGL, lv.color_make(0,0xff,0));
        this.label1.set_text("Anim1");
		this.label1.set_pos(this.scr_w, this.scr_w);
    }

    resume() {
        print("resume");
        lv.gesture_disable();
    }
    pause(){
        print("pause");
        lv.gesture_enable();
    }
    stop(){
        print("stop");
        this.anim.del();
        this.anim1.del();
        this.anim = null;
        this.anim1 = null;
    }
}

globalThis.JA_app5 = {
    root:ja_app
};
app_get_str("key_qjs_name","ja_app5"); 