export declare function print(str: any): any;

/**
 * 应用程序, 由APP framework创建调用。
 *
 */
export declare class app {

    /**
     * 创建app对象。
     * @param is_watchface 1：表盘应用， 2：普通应用。
     */	
    constructor(is_watchface: number);

    /**
     * APP启动
     *
     */
    start();

    /**
     * APP 恢复运行。
     */
    resume();

    /**
     * APP 暂停运行。
     */
    pause();

    /**
     * APP 停止运行，退出。
     */
    stop();
	
    /**
     * 注册APP的回调。
     *
     * @param callback 回调函数
     * @param period 回调间隔，单位 ms
     * @returns 返回RET_OK表示成功，否则表示失败。
     */
    task(callback: Function, period: number);
};


/**
 * obj, LVGL的基类。
 *
 */
export declare class obj {
    /**
     * 创建对象。
     */	
    constructor();

    /**
     * 创建对象绑定的lv_obj
     * @param parent 需要创建lv_obj的parent lv_obj, 采用整数表示
     * @returns 返回创建的lv_obj, 采用整数表示。
     */	
    create(parent: number) : number;
	
    /**
     * 设置对象绑定的lv_obj_t
     * @param obj 绑定的 lv_obj, 采用整数表示
     */	
    set_obj(obj: number);
	

    /**
     * 删除对象绑定的lv_obj_t
     */	
    delete();
	
    /**
     * 注册lv_obj的回调。
     *
     * @param callback 回调函数
     */
    set_event_cb(callback: Function);

	/*
	其他的函数 xxx 和 lv_obj_xxx 一一对应
	*/
};


