import * as lv from "lv"
import { app } from "lvapp"
import { label } from "/support_script/qjs/label.js"
import { img } from "/support_script/qjs/img.js"
import {app_get_str} from "./JA_app2_language.js"
import * as lv_enums from "/support_script/qjs/lv_enums.js"



class ja_app extends app {
	constructor() {
		super();
        this.zoom = 256;
        this.img_path = this.path() + "flower.bin";
    }

    get_key_name(key){
        if(key == lv_enums.KEY_UP) return "KEY_UP";
        else if(key == lv_enums.KEY_DOWN) return "KEY_DOWN";
        else if(key == lv_enums.KEY_RIGHT) return "KEY_RIGHT";
        else if(key == lv_enums.KEY_LEFT) return "KEY_LEFT";
        else if(key == lv_enums.KEY_ESC) return "KEY_ESC";
        else if(key == lv_enums.KEY_DEL) return "KEY_DEL";
        else if(key == lv_enums.KEY_BACKSPACE) return "KEY_BACKSPACE";
        else if(key == lv_enums.KEY_ENTER) return "KEY_ENTER";
        else if(key == lv_enums.KEY_NEXT) return "KEY_NEXT";
        else if(key == lv_enums.KEY_PREV) return "KEY_PREV";
        else if(key == lv_enums.KEY_HOME) return "KEY_HOME";
        else if(key == lv_enums.KEY_END) return "KEY_END";
        else return "Unkown";
    }

    keypad_handler(key, state) {
        this.key_label.set_text(this.get_key_name(key));
        this.key_label.align_to(this.key_tips.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 10, 0);
        if(state == 1)
            this.key_status.set_text("pressed");
        else
            this.key_status.set_text("released");
        this.key_status.align_to(this.key_label.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 10, 0);
        if(key == lv_enums.KEY_HOME && state == 1){
            return 1;   //block home key default function
        }
        return 0;
    }

    wheel_handler(key) {
        this.wheel_label.set_text(this.get_key_name(key));
        this.wheel_label.align_to(this.wheel_tips.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 10, 0);
        
        this.wheel_status.set_text("pressed");
        this.wheel_status.align_to(this.wheel_label.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 10, 0);
        if(key == lv_enums.KEY_UP){
            this.zoom += 10;
        }
        else if(key == lv_enums.KEY_DOWN){
            if(this.zoom < 10) return 0;
            this.zoom -= 10;
        }
        print(this.zoom);
        if(this.zoom > 512) this.zoom = 512;
        this.img.set_zoom(this.zoom);
    }

    start() {

        this.key_tips = new label(this.root());
        this.key_tips.set_local_font(lv_enums.FONT_TITLE, lv.color_make(0xff,0xff,0xff));
        this.key_tips.set_text("Key");
        this.key_tips.align(lv_enums.ALIGN_TOP_LEFT, 20, 20);
        
        this.key_label = new label(this.root());
        this.key_label.set_local_font(lv_enums.FONT_TITLE, lv.color_make(0xff,0,0));
        this.key_label.set_text("--");
        this.key_label.align_to(this.key_tips.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 10, 0);

        this.key_status = new label(this.root());
        this.key_status.set_local_font(lv_enums.FONT_TITLE, lv.color_make(0xff,0,0));
        this.key_status.set_text("--");
        this.key_status.align_to(this.key_label.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 10, 0);

        this.wheel_tips = new label(this.root());
        this.wheel_tips.set_local_font(lv_enums.FONT_TITLE, lv.color_make(0xff,0xff,0xff));
        this.wheel_tips.set_text("wheel");
        this.wheel_tips.align_to(this.key_tips.nativeobj, lv_enums.ALIGN_OUT_BOTTOM_LEFT, 0, 10);
        
        this.wheel_label = new label(this.root());
        this.wheel_label.set_local_font(lv_enums.FONT_TITLE, lv.color_make(0,0xff,0));
        this.wheel_label.set_text("--");
        this.wheel_label.align_to(this.wheel_tips.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 10, 0);

        this.wheel_status = new label(this.root());
        this.wheel_status.set_local_font(lv_enums.FONT_TITLE, lv.color_make(0, 0xff,0));
        this.wheel_status.set_text("--");
        this.wheel_status.align_to(this.wheel_label.nativeobj, lv_enums.ALIGN_OUT_RIGHT_MID, 10, 0);

        this.img = new img(this.root());
        this.img.set_src(this.img_path);
        this.img.set_zoom(this.zoom);
        this.img.align(lv_enums.ALIGN_BOTTOM_MID, 0, -10);

    }

    resume() {
        this.keypad(
            function (key, state) {
                return this.keypad_handler(key, state);
            }
        );
        this.wheel(
            function (key) {
                this.wheel_handler(key);
            }
        );
    }
    pause(){
        this.keypad();
        this.wheel();
    }
}

globalThis.JA_app2 = {
    root:ja_app
};
app_get_str("key_qjs_name","ja_app2");ܻj7