/**
  ******************************************************************************
  * @file   main.c
  * @author Sifli software development team
  ******************************************************************************
*/
/**
 * @attention
 * Copyright (c) 2021 - 2021,  Sifli Technology
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form, except as embedded into a Sifli integrated circuit
 *    in a product or a software update for such product, must reproduce the above
 *    copyright notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of Sifli nor the names of its contributors may be used to endorse
 *    or promote products derived from this software without specific prior written permission.
 *
 * 4. This software, with or without modification, must only be used with a
 *    Sifli integrated circuit.
 *
 * 5. Any software provided in binary form under this license must not be reverse
 *    engineered, decompiled, modified and/or disassembled.
 *
 * THIS SOFTWARE IS PROVIDED BY SIFLI TECHNOLOGY "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY, NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL SIFLI TECHNOLOGY OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <rtthread.h>
#include <rtdevice.h>
#include <board.h>
#include <stdlib.h>
#include <string.h>
#include "register.h"
//#include "dfu.h"
//#include "drv_flash.h"
#include "drv_io.h"

int32_t g_algo_ret = 0;

void bt_rf_cal(void)
{
    return;
}

long list_thread(void)
{
    return  0;
}

static int efuse_uid_read(int argc, char **argv)
{
    uint8_t data[16] = {0};

    HAL_EFUSE_Read(0, data, 16);

    rt_kprintf("read uid from efuse:");
    for (int m = 0; m < 16; m++)
    {
        rt_kprintf("%02x", data[m]);
    }
    rt_kprintf("\n");
    rt_kprintf("EFUSE_UID_READ_PASS\n");
    rt_kprintf("EFUSE_UID_READ_PASS\n");

    return 0;

}
MSH_CMD_EXPORT(efuse_uid_read, efuse_uid_read);

static int get_result(int argc, char **argv)
{
    int r;
    
    if(g_algo_ret == 1)
    {
        rt_kprintf("algo_result:PASS\n");
    }
    else
    {
        rt_kprintf("algo_result:FAIL\n");
    }
    rt_kprintf("OK\n");

    return 0;
}
MSH_CMD_EXPORT(get_result, cmd for get result);

void algo_task_thread(void* parameter)
{
    // add algo code

    rt_kprintf("algo_result:PASS\n");
    g_algo_ret = 1;
}

int main(void)
{
    rt_kprintf("OK\n");
    rt_kprintf("curent ver 2024_1108\n");
    
    rt_thread_t algo_task_handle;
    algo_task_handle = rt_thread_create("algo_task", algo_task_thread, RT_NULL, 2048, FINSH_THREAD_PRIORITY+1, 10);  //RT_MAIN_THREAD_PRIORITY
    rt_thread_startup(algo_task_handle);
    //rt_kprintf("algo_result:PASS\n");
    //g_algo_ret = 1;

    while (1)
    {
        rt_thread_delay(rt_tick_from_millisecond(300000));
    }

    return RT_EOK;
}


